/*
 * ILiadManifest.java
 *
 * Created on 30 maart 2007, 19:58
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package iliadmanifestcreator;

import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.print.attribute.standard.DateTimeAtCompleted;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.xml.xpath.*;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;

/**
 *
 * @author Bert
 */
public class ILiadManifest {
    //manifest types
    static final int MANIFEST_NO_TYPE = 0;
    static final int MANIFEST_FILE = 1;
    static final int MANIFEST_DIRECTORY = 2;
    
    //regular expression which should match all xml tags (<tag>, <tag/> and </tag>)
    static final Pattern TagsPattern = Pattern.compile("\\</?[a-zA-Z\\-]+ ?/?\\>", Pattern.MULTILINE | Pattern.CANON_EQ);
    //date format used in the date propertu (ex: 2007-01-31T23:59:59)
    static final SimpleDateFormat sdfDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    
    //XParh object for parsing xml file
    XPath xPath = XPathFactory.newInstance().newXPath();
    
    //properties
    // dc-metadata
    public String strTitle = null;
    public String strDescription = null;
    public Date dDate = null;
    // y-metadata
    public String strStartPage = null;
    public String strImage = null;
    // directory
    public String strDirectoryContent = null;
    
    //xml data
    private Document docManifestXml = null;
    
    /** Creates new form MainFrame */
    public ILiadManifest(int nManifestType) {
        createEmptyDocument(nManifestType);
    }
    
    public ILiadManifest() {
        //fill in the date with the current time
        dDate = new Date();
    }
    
    public ILiadManifest(String strManifestFile) {
        readFromFile(strManifestFile);
    }
    
    /**
     *Save the current manifest to an xml file.
     *@param fullPathFilename Absolute path to the destination file
     */
    public boolean save(String fullPathFilename) {
        if (!checkDocument())
            return false;
        
        return writeToFile(fullPathFilename);
    }
    
    /**
     *Resets the reading position to 1, if the position was already present
     */
    public void resetCurrentPosition() {
        if (docManifestXml == null)
            return;
        
        try {
            Element ePosition = (Element)xPath.evaluate("/package/last-location/pagenumber", docManifestXml, XPathConstants.NODE);
            if (ePosition != null)
                ePosition.setTextContent("1");
        } catch (XPathExpressionException ex) {
            ex.printStackTrace();
        }
    }
    
    /**
     *Creates an empty document, with emty nodes.
     *@param nManifestType Type of the manifest (MANIFEST_FILE or MANIFEST_DIRECTORY).
     */
    protected boolean createEmptyDocument(int nManifestType) {
        if (nManifestType != MANIFEST_FILE && nManifestType != MANIFEST_DIRECTORY)
            return false;
        
        //create an empty document (with empty nodes)
        try {
            if (docManifestXml == null) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db;

                db = dbf.newDocumentBuilder();
                docManifestXml = db.newDocument();
            } else {
                docManifestXml.removeChild(docManifestXml.getDocumentElement());
            }
                
                
            //create root
            Element eRoot = docManifestXml.createElement("package");
            docManifestXml.appendChild(eRoot);
            
            //create metadata element
            Element eMetaData = docManifestXml.createElement("metadata");
            eRoot.appendChild(eMetaData);
            
            //create dc-metadata element & children
            Element eDcMetaData = docManifestXml.createElement("dc-metadata");
            eMetaData.appendChild(eDcMetaData);
            eDcMetaData.appendChild(docManifestXml.createElement("Title"));
            eDcMetaData.appendChild(docManifestXml.createElement("Description"));
            eDcMetaData.appendChild(docManifestXml.createElement("Date"));
            
            //create y-metadata & children
            Element eYMetaData = docManifestXml.createElement("y-metadata");
            eMetaData.appendChild(eYMetaData);
            eYMetaData.appendChild(docManifestXml.createElement("image"));

            //type-dependant elements
            switch (nManifestType) {
                case MANIFEST_FILE:
                    eYMetaData.appendChild(docManifestXml.createElement("startpage"));
                    break;
                case MANIFEST_DIRECTORY:
                    Element eDirectory = docManifestXml.createElement("directory");
                    eRoot.appendChild(eDirectory);
                    eDirectory.appendChild(docManifestXml.createElement("content"));
                    break;
            }
            
            //fill in the date
            dDate = new Date();
            
            return true;
        } catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
        
        return false;
    }
    
    /**
     *Checks the document and makes sure all needed nodes exist.
     *@return <code>true</code> if the document was completely checked and missig nodes where
     * added, <code>false</code> if something went wrong during checking.
     */
    protected boolean checkDocument(){
        try {
            if (docManifestXml == null) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db;

                db = dbf.newDocumentBuilder();
                docManifestXml = db.newDocument();
            }

            //create root
            Element eRoot = (Element)xPath.evaluate("/package", docManifestXml, XPathConstants.NODE);
            if (eRoot == null)
                eRoot = (Element)docManifestXml.appendChild(docManifestXml.createElement("package"));

            //create metadata element
            Element eMetaData = (Element)xPath.evaluate("/package/metadata", docManifestXml, XPathConstants.NODE);
            if (eMetaData == null)
                eMetaData = (Element)eRoot.appendChild(docManifestXml.createElement("metadata"));

            //create dc-metadata element & children
            Element eDcMetaData = (Element)xPath.evaluate("/package/metadata/dc-metadata", docManifestXml, XPathConstants.NODE);
            if (eDcMetaData == null)
                eDcMetaData = (Element)eMetaData.appendChild(docManifestXml.createElement("dc-metadata"));
            Element eTitle = (Element)xPath.evaluate("/package/metadata/dc-metadata/Title", docManifestXml, XPathConstants.NODE);
            if (eTitle == null && (strTitle != null && strTitle.length()>0))
                eTitle = (Element)eDcMetaData.appendChild(docManifestXml.createElement("Title"));
            Element eDescription = (Element)xPath.evaluate("/package/metadata/dc-metadata/Description", docManifestXml, XPathConstants.NODE);
            if (eDescription == null && (strDescription != null && strDescription.length()>0))
                eDescription = (Element)eDcMetaData.appendChild(docManifestXml.createElement("Description"));
            Element eDate = (Element)xPath.evaluate("/package/metadata/dc-metadata/Date", docManifestXml, XPathConstants.NODE);
            if (eDate == null && dDate != null)
                eDate = (Element)eDcMetaData.appendChild(docManifestXml.createElement("Date"));

            //create y-metadata & children
            Element eYMetaData = (Element)xPath.evaluate("/package/metadata/y-metadata", docManifestXml, XPathConstants.NODE);
            if (eYMetaData == null)
                eYMetaData = (Element)eMetaData.appendChild(docManifestXml.createElement("y-metadata"));
            Element eImage = (Element)xPath.evaluate("/package/metadata/y-metadata/image", docManifestXml, XPathConstants.NODE);
            if (eImage == null && (strImage != null && strImage.length()>0))
                eImage = (Element)eYMetaData.appendChild(docManifestXml.createElement("image"));
            Element eStartPage = (Element)xPath.evaluate("/package/metadata/y-metadata/startpage", docManifestXml, XPathConstants.NODE);
            if (eStartPage == null && (strStartPage != null && strStartPage.length()>0))
                eStartPage = (Element)eYMetaData.appendChild(docManifestXml.createElement("startpage"));
            
            //create directory & children
            if (strDirectoryContent != null && strDirectoryContent.length()>0) {
                Element eDirectory = (Element)xPath.evaluate("/package/directory", docManifestXml, XPathConstants.NODE);
                if (eDirectory == null)
                    eDirectory = (Element)eRoot.appendChild(docManifestXml.createElement("directory"));
                Element eContent = (Element)xPath.evaluate("/package/directory/content", docManifestXml, XPathConstants.NODE);
                if (eContent == null)
                    eContent = (Element)eDirectory.appendChild(docManifestXml.createElement("content"));
            }
            
            return true;
        } catch (DOMException ex) {
            ex.printStackTrace();
        } catch (XPathExpressionException ex) {
            ex.printStackTrace();
        } catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }

        return false;
    }

    
    /**
     *Saves the current DOM tree to the provided file
     *@param fullPathFilename Full path to the destination text file
     */
    protected boolean writeToFile(String strFullPathFilename) {
        /* Note: We will write the document to a string first, and replace
         * the ##### by &#10;
         * I didn't find any other way to do this (yet). Working with XSL
         * stylesheets is a possibility, but I'm still unable to get that working.
         * The stylesheet below should be close to the solution, but I was tired
         * of it after 6 hours of searching without a working result.
         */
//            // Prepare the xslt - force &#10; to be outputted literally (otherwise it's replaced by &amp;#10;)
//            //  This stylesheed copies all nodes, except the 'description' tag. For that tag
//            //  it tries to replace the line break with '&#10;' ... I was unable to catch the line break however
//            String strXsl = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + 
//                    "<xsl:stylesheet " +
//                    "      version=\"1.0\"" +
//                    "      xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"" +
//                    "      xmlns:java=\"java\">\n" +
//                    "   <xsl:template match=\"@*|node()\">" +
//                    "       <xsl:copy>" +
//                    "           <xsl:apply-templates select=\"@*|node()\"/>" +
//                    "       </xsl:copy>" +
//                    "   </xsl:template>\n" +
//                    "   <xsl:template match=\"description\">\n" +
//                    "      <xsl:variable name=\"strDescr\" select=\"java:lang.String.new(.)\"/>\n" +
//                    "      <xsl:variable name=\"strFrom\" select=\"java:lang.String.new('\\u000D')\"/>\n" +
//                    "      <xsl:variable name=\"strTo\" select=\"java:lang.String.new('&#10;')\"/>\n" +
//                    "      <xsl:value-of select=\"java:replace($strDescr,$strFrom,$strTo)\"/>\n" +
//                    "   </xsl:template>\n" +
//                    "</xsl:stylesheet>";
//            StreamSource srcXsl = new StreamSource(new StringReader(strXsl));
//            //you can pass this srcXsl object to the factory.newTransformer(); function
        
        
        try {
            // Pre-processing
            if (!saveParametersToManifest())
                return false;
            docManifestXml.normalizeDocument();
            
            // Prepare the DOM document
            Source source = new DOMSource(docManifestXml);
            
            // Prepare the writer - we write to a string first!
            StringWriter writer = new StringWriter();
            Result result = new StreamResult(writer);
            
            // Write the DOM document to the stringwriter
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", new Integer(4));

            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
            transformer.setOutputProperty(OutputKeys.METHOD, "xml");
            transformer.setOutputProperty(OutputKeys.INDENT, "yes");
            transformer.transform(source, result);
            
            //write the string to the file, replacing the ##### on the fly
            FileOutputStream fos = new FileOutputStream(strFullPathFilename);
            OutputStreamWriter osw = new OutputStreamWriter(fos, "UTF-8");
            osw.write(writer.toString().replace("#####", "&#10;"));
            osw.close();
            
            return true;
        } catch (TransformerException te) {
            te.printStackTrace();
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
        
        return false;
    }
    
    /**
     *Fills the arguments of the object with the data found in the specified
     *manifest file. This function calls the implementation-specific <code>
     * ProcessManifest</code> function to process the manifest completely
     *@param strManifestXml Full path to a valid iRex manifest file
     *@return <code>true</code> if processing succeeded, <code>false</code>
     *         otherwise
     */
    protected boolean readFromFile(String strManifestXml) {
        if (strManifestXml == null || strManifestXml.length()==0)
            return false;
        
        try {
            //open the file
            File file = new File(strManifestXml);
            if ( !file.exists() )
                return false;
            
            //get the file contents
            String strManifestText = readTextFile(strManifestXml);
            
            // replace trailing whitespace to allow parsing
            strManifestText = strManifestText.trim();
            // replace all white space (tabs, newlines, ...) by spaces because
            // they mess up the formatting when writing the file
            strManifestText = strManifestText.replaceAll("[ \t\r\n]+", " ");
            // for some reason, white space BETWEEN the tags messes up the 
            // final formatting too, so let's remove that too
            strManifestText = strManifestText.replaceAll("> <", "><");
            
            //replace "&#13;" (\r) by "&#10;" (\n) (the "&#10;" is (correctly) recognized by the xml parsing 
            // functions as a line break, the "&#13;" as a carriage return, which shows up incorrectly.
            strManifestText = strManifestText.replace("&#13;", "&#10;");
            
            //create document from string
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            docManifestXml = db.parse(new InputSource(new StringReader(strManifestText)));
            docManifestXml.getDocumentElement().normalize();
            
            //process manifest
            return loadParametersFromManifest(docManifestXml);
            
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        return false;
    }
    
    /**
     *This function saves all parameters to the DOM document
     * @param docManifestXml the <code>org.w3c.dom.Document</code> object
     *                       representing the manifest file
     * @return <code>true</code> if processing succeeded, <code>false</code>
     *         if an error occured
     */
    private boolean saveParametersToManifest() {
        try {
            Node node = null;
            
            // DC-METADATA
            // title
            node = (Node)xPath.evaluate("/package/metadata/dc-metadata/Title", docManifestXml, XPathConstants.NODE);
            if (node != null)
                node.setTextContent(strTitle.replace("\n", "#####"));
            // description
            node = (Node)xPath.evaluate("/package/metadata/dc-metadata/Description", docManifestXml, XPathConstants.NODE);
            if (node != null)
                node.setTextContent(strDescription.replace("\n", "#####"));
            // date
            node = (Node)xPath.evaluate("/package/metadata/dc-metadata/Date", docManifestXml, XPathConstants.NODE);
            if (node != null && dDate != null)
                node.setTextContent(sdfDateFormat.format(dDate));

            // Y-METADATA
            // startpage
            node = (Node)xPath.evaluate("/package/metadata/y-metadata/startpage", docManifestXml, XPathConstants.NODE);
            if (node != null)
                node.setTextContent(strStartPage);
            // image
            node = (Node)xPath.evaluate("/package/metadata/y-metadata/image", docManifestXml, XPathConstants.NODE);
            if (node != null)
                node.setTextContent(strImage);
            
            // DIRECTORY
            // content
            node = (Node)xPath.evaluate("/package/directory/content", docManifestXml, XPathConstants.NODE);
            if (node != null)
                node.setTextContent(strDirectoryContent);
            
            return true;
        } catch (XPathExpressionException ex) {
            ex.printStackTrace();
        }
        
        return false;
    }
    
    /**
     *This function retrieves all parameters from the DOM document and stores
     *them in the object for later use
     * @param docManifestXml the <code>org.w3c.dom.Document</code> object
     *                       representing the manifest file
     * @return <code>true</code> if processing succeeded, <code>false</code>
     *         if an error occured
     */
    private boolean loadParametersFromManifest(Document docManifestXml) {
        try {
            Object xResult = null;
            
            // DC-METADATA
            // title
            strTitle = (String)xPath.evaluate("/package/metadata/dc-metadata/Title/text()", docManifestXml, XPathConstants.STRING);
            // description
            strDescription = (String)xPath.evaluate("/package/metadata/dc-metadata/Description/text()", docManifestXml, XPathConstants.STRING);
            // date
            xResult = xPath.evaluate("/package/metadata/dc-metadata/Date/text()", docManifestXml, XPathConstants.STRING);
            if (xResult != null) {
                try {
                    dDate = sdfDateFormat.parse((String)xResult);
                } catch (ParseException pe) {}
            }
            
            // Y-METADATA
            // startpage
            strStartPage = (String)xPath.evaluate("/package/metadata/y-metadata/startpage/text()", docManifestXml, XPathConstants.STRING);
            // image
            strImage = (String)xPath.evaluate("package/metadata/y-metadata/image/text()", docManifestXml, XPathConstants.STRING);
            
            // DIRECTORY
            // content
            strDirectoryContent = (String)xPath.evaluate("/package/directory/content/text()", docManifestXml, XPathConstants.STRING);
            
            return true;
        } catch (XPathExpressionException ex) {
            ex.printStackTrace();
        }
        
        return false;
    }
   
    /**
     *Reads the entire contens of a text file
     *@param fullPathFilename Full path to the text file
     *@return The contents of the file, <code>null</code> if an error occured.
     */
    private static String readTextFile(String fullPathFilename) {
        try {
            //input
            FileInputStream fis = new FileInputStream(fullPathFilename);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis, "UTF-8"));
            //output
            StringBuffer sb = new StringBuffer(1024);
            
            char[] chars = new char[1024];
            int numRead = 0;
            while( (numRead = reader.read(chars)) > -1){
                sb.append(String.valueOf(chars));
            }
            
            reader.close();
            
            return sb.toString();
        } catch (IOException ioe) {
            return null;
        }
    }
    
    /**
     *Replaces all tags in the provided string by their lower-case equivalent.
     *@param strSource Source text
     *@return Text with all tags replaced by their lower-case equivalent.
     */
    private static String replaceTagseWithLowerCase(String strSource) {
        StringBuffer sbSource = new StringBuffer();
        Matcher TagMatcher = TagsPattern.matcher(strSource);
        while (TagMatcher.find())
            TagMatcher.appendReplacement(sbSource, TagMatcher.group().toLowerCase());
        TagMatcher.appendTail(sbSource);
        
        return sbSource.toString();
    }
}
